package com.biz.crm.dict.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 数据字典类型表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_dict_type")
@CrmTable(name = "mdm_dict_type",tableNote = "数据字典类型表实体类")
public class MdmDictTypeEntity extends CrmBaseEntity<MdmDictTypeEntity> {

    /**
     * 字典类型编码
     */
	@CrmColumn(name = "dict_type_code", length = 64)
    private String dictTypeCode;

    /**
     * 字典类型名称
     */
	@CrmColumn(name = "dict_type_name", length = 128)
    private String dictTypeName;

    /**
     * 字典类型描述
     */
	@CrmColumn(name = "dict_type_desc", length = 255)
    private String dictTypeDesc;

    /**
     * 字典类型所属模块
     */
	@CrmColumn(name = "dict_type_module", length = 64)
    private String dictTypeModule;

}
