package com.biz.crm.employeedirectory.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 员工通讯录信息实体
 * @author yangshan
 * @date 2021/3/5 14:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_employee_directory")
@ApiModel(value = "MdmEmployeeDirectoryEntity", description = "员工通讯录信息")
@CrmTable(name = "mdm_employee_directory",tableNote = "员工通讯录信息实体")
public class MdmEmployeeDirectoryEntity extends CrmBaseEntity<MdmEmployeeDirectoryEntity> {

    /**
     * userCode
     */
    @CrmColumn(name = "user_code", length = 32)
    private String userCode;

    /**
     * 人员编码
     */
    @CrmColumn(name = "employee_code", length = 32)
    private String employeeCode;

    /**
     * 人员姓名
     */
    @CrmColumn(name = "employee_name", length = 32)
    private String employeeName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 32)
    private String posCode;

    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 32)
    private String posName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 32)
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 32)
    private String orgName;

    /**
     * 电话
     */
    @CrmColumn(name = "phone", length = 32)
    private String phone;

    /**
     * 姓氏首字母
     */
    @CrmColumn(name = "first_name_initials", length = 32)
    private String firstNameInitials;
}
