package com.biz.crm.engineform.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 表单引擎模板的数据层描述实体类
 *
 * @author jerry7
 * @date 2020-11-17 09:25:34
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("engine_form_list_template")
public class EngineFormListTemplateEntity  {

    /**
     * 列表模板的唯一编号
     */
    private String code;

    /**
     * 创建者信息
     */
    private String creator;

    /**
     * 列表模板编号有不同的版本信息，同一编码下的版本信息是唯一的
     */
    private String cversion;

    /**
     * 数据源类型：1、服务源；2、数据视图。默认为2
     */
    private Integer dataSource;

    /**
     * 当前表单模板版本是否是当前表单模板的默认版本
     */
    private Boolean defaultVersion;

    /**
     * 保存的列表模板布局文件文件名
     */
    private String fileName;

    /**
     * 列表模板的修改时间
     */
    private Date modifyTime;

    /**
     * 列表模板的中文说明
     */
    private String name;

    /**
     * 项目名不填写也行，毕竟目前来看只可能是一个项目
     */
    private String projectName;

    /**
     * 列表模板文件的相对目录
     */
    private String relativePath;

    /**
     * 列表模板状态，1：正常；0或者其它值：作废
     */
    private Integer tStatus;

}
