package com.biz.crm.icon.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-12-05 11:10:24
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_icon")
@CrmTable(name = "mdm_icon",tableNote = "图标")
public class MdmIconEntity extends CrmExtTenEntity<MdmIconEntity> {

    /**
     * 图标编码
     */
	@CrmColumn(name = "icon_code", length = 64)
    private String iconCode;

    @ApiModelProperty("图标路径")
	@CrmColumn(name = "icon_url", length = 64)
    private String iconUrl;

    /**
     * 图标名称
     */
	@CrmColumn(name = "icon_name", length = 64)
    private String iconName;

    /**
     * 图标类型
     */
	@CrmColumn(name = "icon_type", length = 64)
    private String iconType;

    /**
     * 图标后缀
     */
	@CrmColumn(name = "icon_suffix", length = 64)
    private String iconSuffix;

    /**
     * 图标样式
     */
	@CrmColumn(name = "icon_style", length = 64)
    private String iconStyle;

    /**
     * 图标效果
     */
	@CrmColumn(name = "icon_effect", length = 64)
    private String iconEffect;

}
