package com.biz.crm.kms.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
 * @author zxw
 */
@ApiModel(value="验收单据")
@Data
@EqualsAndHashCode(callSuper=true)
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "DMS_ACCEPTANCE_VOUCHER")
public class DmsAcceptanceVoucherEntity extends CrmExtTenEntity<DmsAcceptanceVoucherEntity> {
    /**
     * 企业验收单号
     */
    @TableField(value = "order_number")
    @ApiModelProperty(value="企业验收单号")
	@CrmColumn(name = "order_number", length = 64)
    private String orderNumber;

    /**
     * 商超验收单编号
     */
    @TableField(value = "ka_order_number")
    @ApiModelProperty(value="商超验收单编号")
	@CrmColumn(name = "ka_order_number", length = 64)
    private String kaOrderNumber;

    /**
     * 验收日期
     */
    @TableField(value = "acceptance_date")
    @ApiModelProperty(value="验收日期")
	@CrmColumn(name = "acceptance_date", length = 64)
    private String acceptanceDate;

    /**
     * 验收类型
     */
    @TableField(value = "acceptance_type")
    @ApiModelProperty(value="验收类型")
	@CrmColumn(name = "acceptance_type", length = 64)
    private String acceptanceType;

    /**
     * 企业门店/大仓编号
     */
    @TableField(value = "store_code")
    @ApiModelProperty(value="企业门店/大仓编号")
	@CrmColumn(name = "store_code", length = 64)
    private String storeCode;

    /**
     * 企业门店/大仓名称
     */
    @TableField(value = "store_name")
    @ApiModelProperty(value="企业门店/大仓名称")
	@CrmColumn(name = "store_name", length = 64)
    private String storeName;

    /**
     * 关联订货单
     */
    @TableField(value = "relate_order_number")
    @ApiModelProperty(value="关联订货单")
	@CrmColumn(name = "relate_order_number", length = 64)
    private String relateOrderNumber;

    /**
     * 商超门店/大仓编号
     */
    @TableField(value = "ka_store_code")
    @ApiModelProperty(value="商超门店/大仓编号")
	@CrmColumn(name = "ka_store_code", length = 64)
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @TableField(value = "ka_store_name")
    @ApiModelProperty(value="商超门店/大仓名称")
	@CrmColumn(name = "ka_store_name", length = 64)
    private String kaStoreName;

    /**
     * 订货单总金额（含税）
     */
    @TableField(value = "final_order_amount")
    @ApiModelProperty(value="订货单总金额（含税）")
	@CrmColumn(name = "final_order_amount", length = 64)
    private String finalOrderAmount;

    /**
     * 验收单总金额（含税）
     */
    @TableField(value = "final_acceptance_amount")
    @ApiModelProperty(value="验收单总金额（含税）")
	@CrmColumn(name = "final_acceptance_amount", length = 64)
    private String finalAcceptanceAmount;

    /**
     * 单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)
     */
    @TableField(value = "invoices_source")
    @ApiModelProperty(value="单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)")
	@CrmColumn(name = "invoices_source", length = 64)
    private String invoicesSource;

    /**
     * 商超编号
     */
    @TableField(value = "ka_code")
    @ApiModelProperty(value="商超编号")
	@CrmColumn(name = "ka_code", length = 64)
    private String kaCode;

    /**
     * 创建时间
     */
    @TableField(value = "order_create_date")
    @ApiModelProperty(value="创建时间")
	@CrmColumn(name = "order_create_date", length = 64)
    private String orderCreateDate;

    /**
     * 修改时间
     */
    @TableField(value = "order_update_date")
    @ApiModelProperty(value="修改时间")
	@CrmColumn(name = "order_update_date", length = 64)
    private String orderUpdateDate;

    /**
     * 创建用户
     */
    @TableField(value = "order_create_name")
    @ApiModelProperty(value="创建用户")
	@CrmColumn(name = "order_create_name", length = 64)
    private String orderCreateName;

    /**
     * 更新用户
     */
    @TableField(value = "order_update_name")
    @ApiModelProperty(value="更新用户")
	@CrmColumn(name = "order_update_name", length = 64)
    private String orderUpdateName;

    /**
     * 验收数量
     */
    @TableField(value = "acceptance_number")
    @ApiModelProperty(value="验收数量")
	@CrmColumn(name = "acceptance_number", length = 64)
    private String acceptanceNumber;

    /**
     * 验收人
     */
    @TableField(value = "acceptance_username")
    @ApiModelProperty(value="验收人")
	@CrmColumn(name = "acceptance_username", length = 64)
    private String acceptanceUsername;

    /**
     * 验收人名称
     */
    @TableField(value = "acceptance_realname")
    @ApiModelProperty(value="验收人名称")
	@CrmColumn(name = "acceptance_realname", length = 64)
    private String acceptanceRealname;

    /**
     * 库存地编码
     */
    @TableField(value = "inventory_code")
    @ApiModelProperty(value="库存地编码")
	@CrmColumn(name = "inventory_code", length = 64)
    private String inventoryCode;

    /**
     * 库存地名称
     */
    @TableField(value = "inventory_name")
    @ApiModelProperty(value="库存地名称")
	@CrmColumn(name = "inventory_name", length = 64)
    private String inventoryName;

    /**
     * 验收金额（不含税）
     */
    @TableField(value = "acceptance_amount")
    @ApiModelProperty(value="验收金额（不含税）")
	@CrmColumn(name = "acceptance_amount", length = 64)
    private String acceptanceAmount;

    /**
     * 验收税金
     */
    @TableField(value = "acceptance_tax")
    @ApiModelProperty(value="验收税金")
	@CrmColumn(name = "acceptance_tax", length = 64)
    private String acceptanceTax;
}
