package com.biz.crm.kms.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
 * @author zxw
 */
@ApiModel(value="普通单据")
@Data
@EqualsAndHashCode(callSuper=true)
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "DMS_INDENT_VOUCHER")
public class DmsIndentVoucherEntity extends CrmExtTenEntity<DmsIndentVoucherEntity> {
    /**
     * 企业订货单编号
     */
    @TableField(value = "order_number")
    @ApiModelProperty(value="企业订货单编号")
	@CrmColumn(name = "order_number", length = 64)
    private String orderNumber;

    /**
     * 商超订单编号
     */
    @TableField(value = "ka_order_number")
    @ApiModelProperty(value="商超订单编号")
	@CrmColumn(name = "ka_order_number", length = 64)
    private String kaOrderNumber;

    /**
     * 订货审批编号
     */
    @TableField(value = "order_approval_number")
    @ApiModelProperty(value="订货审批编号")
	@CrmColumn(name = "order_approval_number", length = 64)
    private String orderApprovalNumber;

    /**
     * 单据审批
     */
    @TableField(value = "process_state_des")
    @ApiModelProperty(value="单据审批")
	@CrmColumn(name = "process_state_des", length = 64)
    private String processStateDes;

    /**
     * 商超编号
     */
    @TableField(value = "ka_code")
    @ApiModelProperty(value="商超编号")
	@CrmColumn(name = "ka_code", length = 64)
    private String kaCode;

    /**
     * 商超门店/大仓编号
     */
    @TableField(value = "ka_store_code")
    @ApiModelProperty(value="商超门店/大仓编号")
	@CrmColumn(name = "ka_store_code", length = 64)
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @TableField(value = "ka_store_name")
    @ApiModelProperty(value="商超门店/大仓名称")
	@CrmColumn(name = "ka_store_name", length = 64)
    private String kaStoreName;

    /**
     * 企业门店/大仓编号
     */
    @TableField(value = "store_code")
    @ApiModelProperty(value="企业门店/大仓编号")
	@CrmColumn(name = "store_code", length = 64)
    private String storeCode;

    /**
     * 企业门店/大仓名称
     */
    @TableField(value = "store_name")
    @ApiModelProperty(value="企业门店/大仓名称")
	@CrmColumn(name = "store_name", length = 64)
    private String storeName;

    /**
     * 单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)
     */
    @TableField(value = "invoices_source")
    @ApiModelProperty(value="单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)")
	@CrmColumn(name = "invoices_source", length = 64)
    private String invoicesSource;

    /**
     * 经营方式
     */
    @TableField(value = "run_mode")
    @ApiModelProperty(value="经营方式")
	@CrmColumn(name = "run_mode", length = 64)
    private String runMode;

    /**
     * 送货联系人
     */
    @TableField(value = "delivery_contact")
    @ApiModelProperty(value="送货联系人")
	@CrmColumn(name = "delivery_contact", length = 64)
    private String deliveryContact;

    /**
     * 送货地址
     */
    @TableField(value = "delivery_address")
    @ApiModelProperty(value="送货地址")
	@CrmColumn(name = "delivery_address", length = 64)
    private String deliveryAddress;

    /**
     * 送货联系电话
     */
    @TableField(value = "delivery_contact_phone")
    @ApiModelProperty(value="送货联系电话")
	@CrmColumn(name = "delivery_contact_phone", length = 64)
    private String deliveryContactPhone;

    /**
     * 业务区域
     */
    @TableField(value = "business_area")
    @ApiModelProperty(value="业务区域")
	@CrmColumn(name = "business_area", length = 64)
    private String businessArea;

    /**
     * 业务区域负责人
     */
    @TableField(value = "business_area_leader")
    @ApiModelProperty(value="业务区域负责人")
	@CrmColumn(name = "business_area_leader", length = 64)
    private String businessAreaLeader;

    /**
     * SKU数量汇总
     */
    @TableField(value = "max_unit_sum")
    @ApiModelProperty(value="SKU数量汇总")
	@CrmColumn(name = "max_unit_sum", length = 64)
    private String maxUnitSum;

    /**
     * 订单日期
     */
    @TableField(value = "order_date")
    @ApiModelProperty(value="订单日期")
	@CrmColumn(name = "order_date", length = 64)
    private String orderDate;

    /**
     * 交货日期
     */
    @TableField(value = "delivery_date")
    @ApiModelProperty(value="交货日期")
	@CrmColumn(name = "delivery_date", length = 64)
    private String deliveryDate;

    /**
     * 订货单总金额（含税）
     */
    @TableField(value = "final_order_amount")
    @ApiModelProperty(value="订货单总金额（含税）")
	@CrmColumn(name = "final_order_amount", length = 64)
    private String finalOrderAmount;

    /**
     * 登录帐号
     */
    @TableField(value = "user_name")
    @ApiModelProperty(value="登录帐号")
	@CrmColumn(name = "user_name", length = 64)
    private String userName;

    /**
     * 创建时间
     */
    @TableField(value = "order_create_date")
    @ApiModelProperty(value="创建时间")
	@CrmColumn(name = "order_create_date", length = 64)
    private String orderCreateDate;

    /**
     * 修改时间
     */
    @TableField(value = "order_update_date")
    @ApiModelProperty(value="修改时间")
	@CrmColumn(name = "order_update_date", length = 64)
    private String orderUpdateDate;

    /**
     * 创建用户
     */
    @TableField(value = "order_create_name")
    @ApiModelProperty(value="创建用户")
	@CrmColumn(name = "order_create_name", length = 64)
    private String orderCreateName;

    /**
     * 更新用户
     */
    @TableField(value = "order_update_name")
    @ApiModelProperty(value="更新用户")
	@CrmColumn(name = "order_update_name", length = 64)
    private String orderUpdateName;

    /**
     * 公司编码
     */
    @TableField(value = "company")
    @ApiModelProperty(value="公司编码")
	@CrmColumn(name = "company", length = 64)
    private String company;

    /**
     * 公司名称
     */
    @TableField(value = "company_name")
    @ApiModelProperty(value="公司名称")
	@CrmColumn(name = "company_name", length = 64)
    private String companyName;

    /**
     * 售达方编码
     */
    @TableField(value = "sold_to_party_code")
    @ApiModelProperty(value="售达方编码")
	@CrmColumn(name = "sold_to_party_code", length = 64)
    private String soldToPartyCode;

    /**
     * 售达方名称
     */
    @TableField(value = "sold_to_party_name")
    @ApiModelProperty(value="售达方名称")
	@CrmColumn(name = "sold_to_party_name", length = 64)
    private String soldToPartyName;

    /**
     * 送达方编码
     */
    @TableField(value = "delivery_party_code")
    @ApiModelProperty(value="送达方编码")
	@CrmColumn(name = "delivery_party_code", length = 64)
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @TableField(value = "delivery_party_name")
    @ApiModelProperty(value="送达方名称")
	@CrmColumn(name = "delivery_party_name", length = 64)
    private String deliveryPartyName;

    /**
     * 商超产品编码
     */
    @TableField(value = "ka_goods_code")
    @ApiModelProperty(value="商超产品编码")
	@CrmColumn(name = "ka_goods_code", length = 64)
    private String kaGoodsCode;

    /**
     * 商超产品名称
     */
    @TableField(value = "ka_goods_name")
    @ApiModelProperty(value="商超产品名称")
	@CrmColumn(name = "ka_goods_name", length = 64)
    private String kaGoodsName;

    /**
     * 门店分类
     */
    @TableField(value = "store_type")
    @ApiModelProperty(value="门店分类")
	@CrmColumn(name = "store_type", length = 64)
    private String storeType;

    /**
     * 门店分组
     */
    @TableField(value = "store_group")
    @ApiModelProperty(value="门店分组")
	@CrmColumn(name = "store_group", length = 64)
    private String storeGroup;
}
