package com.biz.crm.kms.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
 * @author zxw
 */
@ApiModel(value = "变价单据")
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "DMS_PRICE_VOUCHER")
public class DmsPriceVoucherEntity extends CrmExtTenEntity<DmsPriceVoucherEntity> {
    /**
     * 变价单编号
     */
    @TableField(value = "order_number")
    @ApiModelProperty(value = "变价单编号")
	@CrmColumn(name = "order_number", length = 64)
    private String orderNumber;

    /**
     * 变价单类型
     */
    @TableField(value = "order_type")
    @ApiModelProperty(value = "变价单类型")
	@CrmColumn(name = "order_type", length = 64)
    private String orderType;

    /**
     * 变价单日期
     */
    @TableField(value = "order_date")
    @ApiModelProperty(value = "变价单日期")
	@CrmColumn(name = "order_date", length = 64)
    private String orderDate;

    /**
     * 变价单金额
     */
    @TableField(value = "order_amount")
    @ApiModelProperty(value = "变价单金额")
	@CrmColumn(name = "order_amount", length = 64)
    private String orderAmount;

    /**
     * 供货单价（含税）
     */
    @TableField(value = "supply_unit_price_tax")
    @ApiModelProperty(value = "供货单价（含税）")
	@CrmColumn(name = "supply_unit_price_tax", length = 64)
    private String supplyUnitPriceTax;

    /**
     * 供货单价（税金）
     */
    @TableField(value = "supply_unit_tax")
    @ApiModelProperty(value = "供货单价（税金）")
	@CrmColumn(name = "supply_unit_tax", length = 64)
    private String supplyUnitTax;

    /**
     * 供货单价（不含税）
     */
    @TableField(value = "supply_unit_total_price")
    @ApiModelProperty(value = "供货单价（不含税）")
	@CrmColumn(name = "supply_unit_total_price", length = 64)
    private String supplyUnitTotalPrice;

    /**
     * 商超单价（不含税）
     */
    @TableField(value = "ka_unit_total_price")
    @ApiModelProperty(value = "商超单价（不含税）")
	@CrmColumn(name = "ka_unit_total_price", length = 64)
    private String kaUnitTotalPrice;

    /**
     * 商超单价（含税）
     */
    @TableField(value = "ka_unit_price_tax")
    @ApiModelProperty(value = "商超单价（含税）")
	@CrmColumn(name = "ka_unit_price_tax", length = 64)
    private String kaUnitPriceTax;

    /**
     * 商超单价（税金）
     */
    @TableField(value = "ka_unit_tax")
    @ApiModelProperty(value = "商超单价（税金）")
	@CrmColumn(name = "ka_unit_tax", length = 64)
    private String kaUnitTax;

    /**
     * 商品数量
     */
    @TableField(value = "ka_num")
    @ApiModelProperty(value = "商品数量")
	@CrmColumn(name = "ka_num", length = 64)
    private String kaNum;

    /**
     * 单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)
     */
    @TableField(value = "invoices_source")
    @ApiModelProperty(value = "单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)")
	@CrmColumn(name = "invoices_source", length = 64)
    private String invoicesSource;

    /**
     * 商超门店/大仓编号
     */
    @TableField(value = "ka_store_code")
    @ApiModelProperty(value = "商超门店/大仓编号")
	@CrmColumn(name = "ka_store_code", length = 64)
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @TableField(value = "ka_store_name")
    @ApiModelProperty(value = "商超门店/大仓名称")
	@CrmColumn(name = "ka_store_name", length = 64)
    private String kaStoreName;

    /**
     * 售达方编码
     */
    @TableField(value = "sold_to_party_code")
    @ApiModelProperty(value = "售达方编码")
	@CrmColumn(name = "sold_to_party_code", length = 64)
    private String soldToPartyCode;

    /**
     * 售达方名称
     */
    @TableField(value = "sold_to_party_name")
    @ApiModelProperty(value = "售达方名称")
	@CrmColumn(name = "sold_to_party_name", length = 64)
    private String soldToPartyName;

    /**
     * 送达方编码
     */
    @TableField(value = "delivery_party_code")
    @ApiModelProperty(value = "送达方编码")
	@CrmColumn(name = "delivery_party_code", length = 64)
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @TableField(value = "delivery_party_name")
    @ApiModelProperty(value = "送达方名称")
	@CrmColumn(name = "delivery_party_name", length = 64)
    private String deliveryPartyName;

    /**
     * 创建时间
     */
    @TableField(value = "order_create_date")
    @ApiModelProperty(value = "创建时间")
	@CrmColumn(name = "order_create_date", length = 64)
    private String orderCreateDate;

    /**
     * 修改时间
     */
    @TableField(value = "order_update_date")
    @ApiModelProperty(value = "修改时间")
	@CrmColumn(name = "order_update_date", length = 64)
    private String orderUpdateDate;

    /**
     * 创建用户
     */
    @TableField(value = "order_create_name")
    @ApiModelProperty(value = "创建用户")
	@CrmColumn(name = "order_create_name", length = 64)
    private String orderCreateName;

    /**
     * 更新用户
     */
    @TableField(value = "order_update_name")
    @ApiModelProperty(value = "更新用户")
	@CrmColumn(name = "order_update_name", length = 64)
    private String orderUpdateName;
}
