package com.biz.crm.kms.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
 * @author zxw
 */
@ApiModel(value="退货单据")
@Data
@EqualsAndHashCode(callSuper=true)
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "DMS_RETURN_VOUCHER")
public class DmsReturnVoucherEntity extends CrmExtTenEntity<DmsReturnVoucherEntity> {
    /**
     * 企业订货单编号
     */
    @TableField(value = "order_number")
    @ApiModelProperty(value="企业订货单编号")
	@CrmColumn(name = "order_number", length = 64)
    private String orderNumber;

    /**
     * 客户退货单编号
     */
    @TableField(value = "ka_order_number")
    @ApiModelProperty(value="客户退货单编号")
	@CrmColumn(name = "ka_order_number", length = 64)
    private String kaOrderNumber;

    /**
     * 关联订货单
     */
    @TableField(value = "relate_order_number")
    @ApiModelProperty(value="关联订货单")
	@CrmColumn(name = "relate_order_number", length = 64)
    private String relateOrderNumber;

    /**
     * 客户编码
     */
    @TableField(value = "ka_code")
    @ApiModelProperty(value="客户编码")
	@CrmColumn(name = "ka_code", length = 64)
    private String kaCode;

    /**
     * 客户名称
     */
    @TableField(value = "ka_name")
    @ApiModelProperty(value="客户名称")
	@CrmColumn(name = "ka_name", length = 64)
    private String kaName;

    /**
     * 订单日期
     */
    @TableField(value = "order_date")
    @ApiModelProperty(value="订单日期")
	@CrmColumn(name = "order_date", length = 64)
    private String orderDate;

    /**
     * 退货金额总计（含税）
     */
    @TableField(value = "final_return_amount")
    @ApiModelProperty(value="退货金额总计（含税）")
	@CrmColumn(name = "final_return_amount", length = 64)
    private String finalReturnAmount;

    /**
     * 退货原因
     */
    @TableField(value = "return_reason")
    @ApiModelProperty(value="退货原因")
	@CrmColumn(name = "return_reason", length = 64)
    private String returnReason;

    /**
     * 商超门店/大仓编号
     */
    @TableField(value = "ka_store_code")
    @ApiModelProperty(value="商超门店/大仓编号")
	@CrmColumn(name = "ka_store_code", length = 64)
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @TableField(value = "ka_store_name")
    @ApiModelProperty(value="商超门店/大仓名称")
	@CrmColumn(name = "ka_store_name", length = 64)
    private String kaStoreName;

    /**
     * 登录帐号
     */
    @TableField(value = "user_name")
    @ApiModelProperty(value="登录帐号")
	@CrmColumn(name = "user_name", length = 64)
    private String userName;

    /**
     * 单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)
     */
    @TableField(value = "invoices_source")
    @ApiModelProperty(value="单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)")
	@CrmColumn(name = "invoices_source", length = 64)
    private String invoicesSource;

    /**
     * 企业门店/大仓编号
     */
    @TableField(value = "store_code")
    @ApiModelProperty(value="企业门店/大仓编号")
	@CrmColumn(name = "store_code", length = 64)
    private String storeCode;

    /**
     * 企业门店/大仓名称
     */
    @TableField(value = "store_name")
    @ApiModelProperty(value="企业门店/大仓名称")
	@CrmColumn(name = "store_name", length = 64)
    private String storeName;

    /**
     * 门店所属大区
     */
    @TableField(value = "area_code")
    @ApiModelProperty(value="门店所属大区")
	@CrmColumn(name = "area_code", length = 64)
    private String areaCode;

    /**
     * 业务区域
     */
    @TableField(value = "business_area")
    @ApiModelProperty(value="业务区域")
	@CrmColumn(name = "business_area", length = 64)
    private String businessArea;

    /**
     * 业务区域负责人
     */
    @TableField(value = "business_area_leader")
    @ApiModelProperty(value="业务区域负责人")
	@CrmColumn(name = "business_area_leader", length = 64)
    private String businessAreaLeader;

    /**
     * 创建时间
     */
    @TableField(value = "order_create_date")
    @ApiModelProperty(value="创建时间")
	@CrmColumn(name = "order_create_date", length = 64)
    private String orderCreateDate;

    /**
     * 修改时间
     */
    @TableField(value = "order_update_date")
    @ApiModelProperty(value="修改时间")
	@CrmColumn(name = "order_update_date", length = 64)
    private String orderUpdateDate;

    /**
     * 创建用户
     */
    @TableField(value = "order_create_name")
    @ApiModelProperty(value="创建用户")
	@CrmColumn(name = "order_create_name", length = 64)
    private String orderCreateName;

    /**
     * 更新用户
     */
    @TableField(value = "order_update_name")
    @ApiModelProperty(value="更新用户")
	@CrmColumn(name = "order_update_name", length = 64)
    private String orderUpdateName;
}
