package com.biz.crm.kms.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * @author zxw
 * @date 2021-03-16 15:02
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("dms_voucher_detail")
public class KmsOrderDetailEntity extends CrmExtTenEntity<KmsOrderDetailEntity> {

    @ApiModelProperty("商超产品编号")
    @CrmColumn(name = "ka_goods_code", length = 64)
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    @CrmColumn(name = "ka_goods_name", length = 64)
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    @CrmColumn(name = "goods_bar_code", length = 64)
    private String goodsBarCode;

    @ApiModelProperty("企业产品编码")
    @CrmColumn(name = "goods_code", length = 64)
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    @CrmColumn(name = "goods_name", length = 64)
    private String goodsName;

    @ApiModelProperty("验收金额小计（含税）")
    @CrmColumn(name = "acceptance_amount", length = 64)
    private String acceptanceAmount;

    @ApiModelProperty("产品规格")
    @CrmColumn(name = "specification", length = 64)
    private String specification;

    @ApiModelProperty("订货数量")
    @CrmColumn(name = "order_quantity", length = 64)
    private String orderQuantity;

    @ApiModelProperty("最大单位验收数量")
    @CrmColumn(name = "max_unit_acceptance_quantity", length = 64)
    private String maxUnitAcceptanceQuantity;

    @ApiModelProperty("当前单位")
    @CrmColumn(name = "cur_unit", length = 64)
    private String curUnit;

    @ApiModelProperty("当前单位验收数量")
    @CrmColumn(name = "cur_unit_acceptance_quantity", length = 64)
    private String curUnitAcceptanceQuantity;

    @ApiModelProperty("最大单位")
    @CrmColumn(name = "max_unit", length = 64)
    private String maxUnit;

    @ApiModelProperty("最小单位验收数量")
    @CrmColumn(name = "min_unit_acceptance_quantity", length = 64)
    private String minUnitAcceptanceQuantity;

    @ApiModelProperty("最小单位")
    @CrmColumn(name = "min_unit", length = 64)
    private String minUnit;

    @ApiModelProperty("企业验收单号/企业退货单编号/企业订货单编号")
    @CrmColumn(name = "order_number", length = 64)
    private String orderNumber;

    @ApiModelProperty("最大单位订货数量")
    @CrmColumn(name = "max_unit_order_quantity", length = 64)
    private String maxUnitOrderQuantity;

    @ApiModelProperty("最小单位订货数量")
    @CrmColumn(name = "min_unit_order_quantity", length = 64)
    private String minUnitOrderQuantity;

    @ApiModelProperty("当前单位订货数量")
    @CrmColumn(name = "cur_unit_order_quantity", length = 64)
    private String curUnitOrderQuantity;

    @ApiModelProperty("退货单价/订货单价")
    @CrmColumn(name = "unit_price", length = 64)
    private String unitPrice;

    @ApiModelProperty("客户订货价格")
    @CrmColumn(name = "order_price", length = 64)
    private String orderPrice;

    @ApiModelProperty("对比金额差异")
    @CrmColumn(name = "price_diff", length = 64)
    private String priceDiff;

    @ApiModelProperty("订货金额小计（含税）")
    @CrmColumn(name = "order_amount", length = 64)
    private String orderAmount;

    @ApiModelProperty("单据类型1:订货单，2.退货单，3.验收单，4.变价单")
    @CrmColumn(name = "kms_order_type", length = 64)
    private Integer kmsOrderType;
}
