package com.biz.crm.material.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_material")
@CrmTable(name = "mdm_material",tableNote = "物料表",indexes = {
        @Index(name = "mdm_material_index1",columnList = "product_level_code"),
        @Index(name = "mdm_material_index2",columnList = "material_code",unique = true),
})
public class MdmMaterialEntity extends CrmTreeEntity<MdmMaterialEntity> {


    /**
     * 产品层级编码
     */
	@CrmColumn(name = "product_level_code", length = 64)
    private String productLevelCode;

    /**
     * 物料编码
     */
	@CrmColumn(name = "material_code", length = 64)
    private String materialCode;

    /**
     * 产品名称
     */
	@CrmColumn(name = "material_name", length = 128)
    private String materialName;


    /**
     * ai编码
     */
	@CrmColumn(name = "ai_code", length = 64)
    private String aiCode;

    /**
     * 条形码
     */
	@CrmColumn(name = "bar_code", length = 64)
    private String barCode;

    /**
     * 基本单位
     */
	@CrmColumn(name = "base_unit", length = 64)
    private String baseUnit;

    /**
     * 物料类型
     */
	@CrmColumn(name = "material_type", length = 64)
    private String materialType;

    /**
     * 销售公司
     */
	@CrmColumn(name = "sale_company", length = 64)
    private String saleCompany;

    /**
     * 销售单位
     */
	@CrmColumn(name = "sale_unit", length = 64)
    private String saleUnit;

    /**
     * 规格
     */
	@CrmColumn(name = "specification", length = 64)
    private String specification;

    /**
     * 单位换算系数
     */
	@CrmColumn(name = "unit_conversion", length = 64)
    private String unitConversion;

    /**
     * 成本价格
     */
	@CrmColumn(name = "cost_price", length = 64)
    private String costPrice;

    /**
     * 毛重
     */
	@CrmColumn(name = "gross_weight", length = 64)
    private String grossWeight;

    /**
     * 净重
     */
	@CrmColumn(name = "net_weight", length = 64)
    private String netWeight;

    /**
     * 容量
     */
	@CrmColumn(name = "capacity", length = 64)
    private String capacity;

  /**
   * 标准单位
   */
  @CrmColumn(name = "standard_unit", length = 64)
  private String standardUnit;

  /**
   * 盒码单位转算系数
   */
  @CrmColumn(name = "box_unit_conversion",mysqlType = "decimal(10,2)")
  private BigDecimal boxUnitConversion;

  /**
   * 箱码单位转算系数
   */
  @CrmColumn(name = "case_unit_conversion",mysqlType = "decimal(10,2)")
  private BigDecimal caseUnitConversion;


}
