package com.biz.crm.material.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.Api;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @ClassName: MdmMaterialGroupEntity
 * @Author: yangfan
 * @Description: 物料组entity
 * @Date: 2021/8/19 11:42
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_material_group")
@Api(tags = "MDM-物料组实体")
@CrmTable(name = "mdm_material_group",tableNote = "物料组实体")
public class MdmMaterialGroupEntity extends CrmExtEntity<MdmMaterialGroupEntity> {

  /**
   * 物料组编码
   */
  @CrmColumn(name = "material_group_code", length = 64)
  private String materialGroupCode;

  /**
   * 物料组名称
   */
  @CrmColumn(name = "material_group_name", length = 64)
  private String materialGroupName;

  /**
   * 物料组描述
   */
  @CrmColumn(name = "description", length = 255)
  private String description;

  /**
   * 物料数量
   */
  @CrmColumn(name = "material_num")
  private Integer materialNum;

}
