package com.biz.crm.material.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.Api;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.apache.poi.ss.formula.functions.T;

/**
 * @ClassName: MdmMaterialGroupRelEntity
 * @Author: yangfan
 * @Description: 物料组关联物料entity
 * @Date: 2021/8/19 15:32
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_material_group_rel")
@Api(tags = "MDM-物料组实体")
@CrmTable(name = "mdm_material_group_rel",tableNote = "物料组关系实体")
public class MdmMaterialGroupRelEntity extends CrmBaseEntity<MdmMaterialGroupRelEntity> {
  /**
   * 物料组编码
   */
  @CrmColumn(name = "material_group_code", length = 64)
  private String materialGroupCode;

  /**
   * 物料编码
   */
  @CrmColumn(name = "material_code", length = 64)
  private String materialCode;
}
