package com.biz.crm.material.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.product.model.MdmProductMediaEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @ClassName: MdmMaterialMediaEntity
 * @Author: yangfan
 * @Description: 物料照片entity
 * @Date: 2021/8/16 14:32
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_material_media")
@Api(tags = "MDM-物料图片实体")
@CrmTable(name = "mdm_material_media",tableNote = "物料图片")
public class MdmMaterialMediaEntity extends CrmBaseEntity<MdmMaterialMediaEntity> {
  /**
   * 图片地址
   */
  @CrmColumn(name = "url_address", length = 255)
  private String urlAddress;
  /**
   * 排序位置
   */
  @CrmColumn(name = "range_num", length = 64)
  private Integer rangeNum;
  /**
   * 物料编码
   */
  @CrmColumn(name = "material_code", length = 64)
  private String materialCode;

  /**
   * 物料id
   */
  @CrmColumn(name = "material_id", length = 64)
  private String materialId;

  /**
   * 图片类型(central 主图片 display 陈列图片 detail 详情图片)
   */
  @CrmColumn(name = "business_type", length = 64)
  private String businessType;

  /**
   * 文件名称
   */
  @CrmColumn(name = "file_name", length = 128)
  private String fileName;

  /**
   * 源文件名称
   */
  @CrmColumn(name = "original_file_name", length = 128)
  private String originalFileName;

  /**
   * 地址
   */
  @CrmColumn(name = "relative_local", length = 128)
  private String relativeLocal;
}
