package com.biz.crm.mdmbuglistmanagement.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.poi.ss.formula.functions.T;

/**
 * bug管理主表实体类
 *
 * @author lf
 * @date 2021-01-29 11:23:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_bug_list_management")
@CrmTable(name = "mdm_bug_list_management",tableNote = "bug管理主表实体类")
public class MdmBugListManagementEntity extends CrmBaseEntity<T> {

    /**
     * 禅道bug编号
     */
	@CrmColumn(name = "bug_code", length = 64)
    private String bugCode;

    /**
     * bug名称
     */
	@CrmColumn(name = "bug_name", length = 64)
    private String bugName;

    /**
     * bug负责人
     */
	@CrmColumn(name = "charge_man", length = 64)
    private String chargeMan;

    /**
     * 手机号作为负责人code
     */
	@CrmColumn(name = "code_by_phone", length = 64)
    private String codeByPhone;
    /**
     * 是否已完成(发布到远程仓库后,该字段值为Y,默认为N)
     */
	@CrmColumn(name = "is_complete", length = 64)
    private String isComplete;

    /**
     * 后端是否已解决(Y,N)
     */
	@CrmColumn(name = "is_backend_fix", length = 64)
    private String isBackendFix;

    /**
     * 前端是否已解决(Y,N)
     */
	@CrmColumn(name = "is_fore_end_fix", length = 64)
    private String isForeEndFix;

    /**
     * 是否dev测试中(Y,N)
     */
	@CrmColumn(name = "is_dev_testing", length = 64)
    private String isDevTesting;

    /**
     * dev是否测试通过(Y,N)
     */
	@CrmColumn(name = "is_dev_pass_test", length = 64)
    private String isDevPassTest;

    /**
     * 后端是否已部署(Y,N)
     */
	@CrmColumn(name = "is_backend_arr_uat", length = 64)
    private String isBackendArrUat;

    /**
     * 前端是否已部署uat(Y,N)
     */
	@CrmColumn(name = "is_fore_end_arr_uat", length = 64)
    private String isForeEndArrUat;

    /**
     * uat 测试中(Y,N)
     */
	@CrmColumn(name = "is_uat_testing", length = 64)
    private String isUatTesting;

    /**
     * uat 测试通过(Y,N)
     */
	@CrmColumn(name = "is_uat_pass_test", length = 64)
    private String isUatPassTest;

    /**
     * 后端是否已部署 pro(Y,N)
     */
	@CrmColumn(name = "is_backend_arr_pro", length = 64)
    private String isBackendArrPro;

    /**
     * 前端是否已部署(Y,N)
     */
	@CrmColumn(name = "is_fore_end_arr_pro", length = 64)
    private String isForeEndArrPro;

    /**
     * pro 测试中(Y,N)
     */
	@CrmColumn(name = "is_pro_testing", length = 64)
    private String isProTesting;

    /**
     * pro测试通过
     */
	@CrmColumn(name = "is_pro_pass_test", length = 64)
    private String isProPassTest;

    /**
     * 是否紧急
     */
	@CrmColumn(name = "is_urgent", length = 64)
    private String isUrgent;

    /**
     * 待发布
     */
	@CrmColumn(name = "is_wait_complete", length = 64)
    private String isWaitComplete;

    /**
     * dev 待测试
     */
	@CrmColumn(name = "is_dev_wait_test", length = 64)
    private String isDevWaitTest;
    /**
     * uat 待测试
     */
	@CrmColumn(name = "is_uat_wait_test", length = 64)
    private String isUatWaitTest;
    /**
     * pro 待测试
     */
	@CrmColumn(name = "is_pro_wait_test", length = 64)
    private String isProWaitTest;
    /**
     * 禅道链接
     */
	@CrmColumn(name = "zt_url", length = 64)
    private String ZtUrl;

    /**
     * 所属模块
     */
	@CrmColumn(name = "owning_module", length = 64)
    private String owningModule;

    /**
     * 待发布时间
     */
	@CrmColumn(name = "release_date", length = 64)
    private String releaseDate;
    /**
     * 发布版本
     */
	@CrmColumn(name = "release_version", length = 64)
    private String releaseVersion;
    /**
     * 需要完成时间
     */
	@CrmColumn(name = "need_mission_date", length = 64)
    private String needMissionDate;

}
