package com.biz.crm.notice.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 公告管理评论 实体类
 *
 * @author yangshan
 * @date 2021-2-4 10:56:02
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_notice_comment")
@CrmTable(name = "mdm_notice_comment",tableNote = "公告管理评论")
public class MdmNoticeCommentEntity extends CrmBaseEntity<MdmNoticeCommentEntity> {
    /**
     * 公告id
     */
	@CrmColumn(name = "notice_id", length = 64)
    private String noticeId;

    /**
     * 评论人姓名
     */
	@CrmColumn(name = "comment_name", length = 64)
    private String commentName;

    /**
     * 评论人职位
     */
	@CrmColumn(name = "comment_pos_name", length = 64)
    private String commentPosName;

    /**
     * 评论人组织
     */
	@CrmColumn(name = "comment_org_name", length = 64)
    private String commentOrgName;

    /**
     * 评论内容
     */
	@CrmColumn(name = "comment_text", length = 64)
    private String commentText;

    /**
     * 评论时间
     */
	@CrmColumn(name = "comment_time", length = 64)
    private String commentTime;

    /**
     * 点赞数量
     */
	@CrmColumn(name = "comment_num_likes", length = 64)
    private String commentNumLikes;

    /**
     * 可见状态
     */
	@CrmColumn(name = "visible_state", length = 64)
    private String visibleState;
}
