package com.biz.crm.notice.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 公告管理 实体类
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_notice")
@CrmTable(name = "mdm_notice",tableNote = "公告管理")
public class MdmNoticeEntity extends CrmBaseEntity<MdmNoticeEntity> {

    /**
     * 公告编码 公告编码
     */
    @CrmColumn(name = "notice_code", length = 40 )
    private String noticeCode;
    /**
     * 公告标题 公告标题
     */
    @CrmColumn(name = "notice_title", length = 200 )
    private String noticeTitle;

    /**
     * 公告类型 公告类型
     */
    @CrmColumn(name = "notice_type", length = 20 )
    private String noticeType;

    /**
     * 有效开始时间 有效开始时间
     */
    @CrmColumn(name = "begin_date", length = 30 )
    private String beginDate;

    /**
     * 有效结束时间 有效结束时间
     */
    @CrmColumn(name = "end_date", length = 30 )
    private String endDate;

    /**
     * 公告内容 公告内容
     */
    @CrmColumn(name = "notice_content", length = 500 )
    private String noticeContent;

    /**
     * 公告发布状态
     */
    @CrmColumn(name = "notice_release_status", length = 10 )
    private String noticeReleaseStatus;

    /**
     * 公告置顶状态
     */
    @CrmColumn(name = "notice_top_state", length = 10 )
    private String noticeTopState;

    /**
     * 公告置顶时间
     */
    @CrmColumn(name = "notice_top_time", length = 30 )
    private String noticeTopTime;

    /**
     * 公告评论状态
     */
    @CrmColumn(name = "comment_state", length = 10 )
    private String commentState;
}
