package com.biz.crm.org.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 组织表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_org")
@CrmTable(name = "mdm_org",tableNote = "组织表实体类",indexes = {
        @Index(name = "mdm_org_index1",columnList = "org_code",unique = true),
        @Index(name = "mdm_org_index2",columnList = "rule_code",unique = true),
        @Index(name = "mdm_org_index3",columnList = "parent_code")
})
public class MdmOrgEntity extends CrmTreeTenEntity<MdmOrgEntity> {

    /**
     * 组织编码
     */
	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 组织名称
     */
	@CrmColumn(name = "org_name", length = 128)
    private String orgName;

    /**
     * 组织类型
     */
	@CrmColumn(name = "org_type", length = 64)
    private String orgType;

    /**
     * 组织描述
     */
	@CrmColumn(name = "org_desc", length = 128)
    private String orgDesc;

    /**
     * 上级组织编码
     */
	@CrmColumn(name = "parent_code", length = 64)
    private String parentCode;

    /**
     * 对应SAP组织编码
     */
	@CrmColumn(name = "sap_org_code", length = 64)
    private String sapOrgCode;

    /**
     * 对应SAP组织编码利润中心编码
     */
	@CrmColumn(name = "sap_profit_org_code", length = 64)
    private String sapProfitOrgCode;

    /**
     * 对应SAP组织编码成本中心编码
     */
	@CrmColumn(name = "sap_cost_org_code", length = 64)
    private String sapCostOrgCode;

}
