package com.biz.crm.org.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 组织和行政区域关联表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 10:42:46
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_org_region")
@CrmTable(name = "mdm_org_region",tableNote = "组织和行政区域关联表实体类")
public class MdmOrgRegionEntity extends BaseIdEntity {

    /**
     * 组织编码
     */
	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 国家编码
     */
	@CrmColumn(name = "country_code", length = 64)
    private String countryCode;

    /**
     * 省份编码
     */
	@CrmColumn(name = "province_code", length = 64)
    private String provinceCode;

    /**
     * 城市编码
     */
	@CrmColumn(name = "city_code", length = 64)
    private String cityCode;

    /**
     * 区县编码
     */
	@CrmColumn(name = "district_code", length = 64)
    private String districtCode;

    /**
     * 乡镇编码
     */
	@CrmColumn(name = "township_code", length = 64)
    private String townshipCode;

}
