package com.biz.crm.parametermanage.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 参数配置实体类
 *
 * @author Tao.Chen
 * @date 2020-11-24 10:47:10
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_parameter_manage")
@CrmTable(name = "mdm_parameter_manage",tableNote = "参数配置实体类")
public class MdmParameterManageEntity extends CrmBaseEntity<MdmParameterManageEntity> {

    /**
     * 参数
     */
	@CrmColumn(name = "parameter_code", length = 64)
    private String parameterCode;

    /**
     * 参数名称
     */
	@CrmColumn(name = "parameter_name", length = 64)
    private String parameterName;

    /**
     * 默认值
     */
	@CrmColumn(name = "default_value", length = 64)
    private String defaultValue;

    /**
     * 参数值
     */
	@CrmColumn(name = "parameter_value", length = 64)
    private String parameterValue;

    /**
     * 参数说明
     */
	@CrmColumn(name = "parameter_explain", length = 64)
    private String parameterExplain;

    /**
     * 所属模块
     */
	@CrmColumn(name = "parameter_module", length = 64)
    private String parameterModule;

}
