package com.biz.crm.permission.model;




import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 数据权限实体类
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_data_permission")
@CrmTable(name = "mdm_data_permission",tableNote = "数据权限实体类",indexes = {
        @Index(name = "mdm_data_permission_index1",columnList = "role_code"),
        @Index(name = "mdm_data_permission_index2",columnList = "function_code"),
        @Index(name = "mdm_data_permission_index3",columnList = "position_code")
})
public class MdmDataPermissionEntity extends CrmTreeEntity<MdmDataPermissionEntity> {

    /**
     * 角色编码
     */
	@CrmColumn(name = "role_code", length = 64)
    private String roleCode;

    /**
     * 列表配置编码
     */
	@CrmColumn(name = "list_config_code", length = 64)
    private String listConfigCode;

    /**
     * 菜单编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 查询对象编码
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@CrmColumn(name = "permission_obj_code", length = 64)
    private String permissionObjCode;

	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

	@CrmColumn(name = "position_code", length = 64)
    private String positionCode;

    /**
     * 权限维度，数据字典：permission_dimension
     */
	@CrmColumn(name = "permission_dimension", length = 64)
    private String permissionDimension;

    /**
     * 数据来源，数据字典：permission_resource
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@CrmColumn(name = "permission_resource", length = 64)
    private String permissionResource;

    /**
     * 查询方式
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@CrmColumn(name = "permission_search_type", length = 64)
    private String permissionSearchType;


}
