package com.biz.crm.permission.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author zxw
 * @date 2021-01-07 10:28:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_data_permission_extend_detail")
@CrmTable(name = "mdm_data_permission_extend_detail",indexes = {
        @Index(name = "permission_extend_id", columnList = "permission_extend_id")
})
public class MdmDataPermissionExtendDetailEntity extends CrmExtTenEntity<MdmDataPermissionExtendDetailEntity> {

    /**
     * 编码
     */
	@CrmColumn(name = "detail_code", length = 64,note = "编码")
    private String detailCode;

    @CrmColumn(name = "detail_name", length = 64,note = "名称")
    private String detailName;

    /**
     * 对象权限扩展id
     */
    @CrmColumn(name = "permission_extend_id",length = 64,note = "对象权限扩展id")
    private String permissionExtendId;

    /**
     * 权限对象编码
     */
	@CrmColumn(name = "permission_obj_code", length = 64,note = "权限对象编码")
    private String permissionObjCode;

}
