package com.biz.crm.permission.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 实体类
 *
 * @author zxw
 * @date 2021-01-07 10:28:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_data_permission_extend")
@CrmTable(name = "mdm_data_permission_extend")
public class MdmDataPermissionExtendEntity extends CrmExtTenEntity<MdmDataPermissionExtendEntity> {

    /**
     * 编码
     */
	@CrmColumn(name = "code", length = 64)
    private String code;

    /**
     * 查询方式
     */
	@CrmColumn(name = "permission_search_type", length = 64)
    private String permissionSearchType;

    /**
     * 角色编码
     */
	@CrmColumn(name = "role_code", length = 64)
    private String roleCode;

    /**
     * 菜单编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 列表编码
     */
	@CrmColumn(name = "list_config_code", length = 64)
    private String listConfigCode;


    /**
     * 权限对象编码
     */
	@CrmColumn(name = "permission_obj_code", length = 64)
    private String permissionObjCode;

    /**
     * 数据来源
     */
	@CrmColumn(name = "permission_resource", length = 64)
    private String permissionResource;

    /**
     * 客户编码
     */
	@CrmColumn(name = "customer_code",length = 64)
    private String customerCode;

}
