package com.biz.crm.permission.model;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-10-26 10:42:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_permission")
@CrmTable(name = "mdm_permission",tableNote ="" ,indexes = {
        @Index(name = "mdm_permission_index1",columnList = "function_code")
})
public class MdmPermissionEntity extends CrmTreeEntity<MdmPermissionEntity> {

    /**
     * 列表编码
     */
	@CrmColumn(name = "list_config_code", length = 64)
    private String listConfigCode;

    /**
     * 所属菜单编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 所属模块类型
     */
	@CrmColumn(name = "model_type", length = 64)
    private String modelType;

    /**
     * 选中的权限对象，以逗号分割，数据字典permission_obj
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@CrmColumn(name = "permission_obj", length = 64)
    private String permissionObj;

}
