package com.biz.crm.poi.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 高德地图城市表
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_amap_poi_city")
@CrmTable(name = "mdm_amap_poi_city", tableNote = "高德地图城市表", indexes = {
        @Index(name = "mdm_amap_poi_city_index1", columnList = "amap_code"),
})
public class MdmAmapPoiCityEntity extends BaseIdEntity {

    @CrmColumn(name = "amap_code", nullable = false, unique = true, length = 16, note = "高德城市编码")
    private String amapCode;

    @CrmColumn(name = "amap_name", nullable = false, length = 128, note = "高德城市名称")
    private String amapName;

    @CrmColumn(name = "region_level", length = 4, note = "高德城市级别")
    private String regionLevel;

    @CrmColumn(name = "parent_code", length = 16, note = "上级高德城市编码")
    private String parentCode;

    @CrmColumn(name = "region_code", length = 16, note = "CRM行政区域编码")
    private String regionCode;

    @CrmColumn(name = "short_city_code", length = 16, note = "城市区号")
    private String shortCityCode;

    @CrmColumn(name = "amap_pinyin", length = 64, note = "高德城市名称拼音")
    private String amapPinyin;

    @CrmColumn(name = "center_longitude", length = 32, note = "中心经度")
    private String centerLongitude;

    @CrmColumn(name = "center_latitude", length = 32, note = "中心纬度")
    private String centerLatitude;

    @CrmColumn(name = "rule_code", length = 32, note = "降维编码")
    private String ruleCode;

}