package com.biz.crm.poi.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;

import javax.persistence.Index;

/**
 * 高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_amap_poi")
@CrmTable(name = "mdm_amap_poi", tableNote = "高德地图Point of Interest表", indexes = {
        @Index(name = "mdm_amap_poi_index1", columnList = "amap_id"),
})
@Document(indexName = "mdm_amap_poi_index", type = "mdm_amap_poi_type", shards = 3)
public class MdmAmapPoiEntity extends BaseIdEntity {

    @Field(type = FieldType.Keyword)
    @CrmColumn(name = "amap_id", length = 32, note = "高德poi唯一ID")
    private String amapId;

    @CrmColumn(name = "parent_amap_id", length = 32, note = "父POI的ID 当前POI如果有父POI，则返回父POI的ID。可能为空")
    private String parentAmapId;

    @Field(type = FieldType.Text)
    @CrmColumn(name = "poi_name", length = 128, note = "名称")
    private String poiName;

    @CrmColumn(name = "type_name", length = 128, note = "兴趣点类型 顺序为大类、中类、小类 例如：餐饮服务;中餐厅;特色/地方风味餐厅")
    private String typeName;

    @Field(type = FieldType.Keyword)
    @CrmColumn(name = "type_code", length = 32, note = "兴趣点类型编码 例如：050118")
    private String typeCode;

    @CrmColumn(name = "biz_type", length = 64, note = "行业类型")
    private String bizType;

    @CrmColumn(name = "address", length = 255, note = "地址 东四环中路189号百盛北门")
    private String address;

    @GeoPointField
    @CrmColumn(name = "location", length = 32, note = "经纬度 格式（维度,经度）")
    private String location;

    @CrmColumn(name = "longitude", length = 32, note = "经度")
    private String longitude;

    @CrmColumn(name = "latitude", length = 32, note = "维度")
    private String latitude;

    @CrmColumn(name = "distance", length = 32, note = "离中心点距离 单位：米；仅在周边搜索的时候有值返回")
    private String distance;

    @CrmColumn(name = "tel", length = 128, note = "POI的电话")
    private String tel;

    @CrmColumn(name = "post_code", length = 32, note = "邮编 extensions=all时返回")
    private String postCode;

    @CrmColumn(name = "website", length = 500, note = "POI的网址  extensions=all时返回")
    private String website;

    @CrmColumn(name = "email", length = 128, note = "POI的电子邮箱  extensions=all时返回")
    private String email;

    @CrmColumn(name = "amap_province_code", length = 32, note = "POI所在省份编码  extensions=all时返回")
    private String amapProvinceCode;

    @CrmColumn(name = "amap_province_name", length = 128, note = "POI所在省份名称 若是直辖市的时候，此处直接显示市名，例如北京市")
    private String amapProvinceName;

    @CrmColumn(name = "amap_city_code", length = 32, note = "城市编码 extensions=all时返回")
    private String amapCityCode;

    @CrmColumn(name = "amap_city_name", length = 128, note = "城市名 若是直辖市的时候，此处直接显示市名，例如北京市")
    private String amapCityName;

    @CrmColumn(name = "amap_district_code", length = 64,note = "区域编码 extensions=all时返回")
    private String amapDistrictCode;

    @CrmColumn(name = "amap_district_name", length = 128, note = "区域名称 区县级别的返回，例如朝阳区")
    private String amapDistrictName;

    @CrmColumn(name = "region_code", length = 32, note = "CRM区县编码")
    private String regionCode;

    @GeoPointField
    @CrmColumn(name = "entr_location", length = 32, note = "POI的入口经纬度，格式（维度,经度）  extensions=all时返回，也可用作于POI的到达点；")
    private String entrLocation;

    @CrmColumn(name = "entr_longitude", length = 32, note = "POI的入口经度")
    private String entrLongitude;

    @CrmColumn(name = "entr_latitude", length = 32, note = "POI的入口维度")
    private String entrLatitude;

    @CrmColumn(name = "navi_poiid", length = 64, note = "POI导航id extensions=all时返回")
    private String naviPoiid;

    @CrmColumn(name = "grid_code", length = 64, note = "地理格ID extensions=all时返回")
    private String gridCode;

    @CrmColumn(name = "alias", length = 128, note = "别名  extensions=all时返回")
    private String alias;

    @CrmColumn(name = "business_area", length = 128, note = "所在商圈  extensions=all时返回")
    private String businessArea;

    @CrmColumn(name = "tag", length = 500, note = "该POI的特色内容 主要出现在美食类POI中，代表特色菜 例如“烤鱼,麻辣香锅,老干妈回锅肉extensions=all时返回")
    private String tag;

    @CrmColumn(name = "poi_photo", length = 500, note = "一张图片")
    private String poiPhoto;

}
