package com.biz.crm.poi.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_amap_poi_photo")
@CrmTable(name = "mdm_amap_poi_photo", tableNote = "高德地图poi图片表", indexes = {
        @Index(name = "mdm_amap_poi_photo_index1", columnList = "amap_id"),
})
public class MdmAmapPoiPhotoEntity extends BaseIdEntity {

    @CrmColumn(name = "amap_id", nullable = false, length = 32, note = "高德地图id")
    private String amapId;

    @CrmColumn(name = "titile", length = 128, note = "图片介绍")
    private String titile;

    @CrmColumn(name = "url", nullable = false, length = 500, note = "具体链接")
    private String url;
}
