package com.biz.crm.poi.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_amap_poi_process")
@CrmTable(name = "mdm_amap_poi_process", tableNote = "高德poi数据抓取进度表", indexes = {
        @Index(name = "amap_poi_process_index1", columnList = "city_code"),
        @Index(name = "amap_poi_process_index2", columnList = "poi_type"),
        @Index(name = "amap_poi_process_index3", columnList = "poi_keyword")
})
public class MdmAmapPoiProcessEntity extends BaseIdEntity {

    @CrmColumn(name = "city_code", nullable = false, length = 32, note = "高德城市编码")
    private String cityCode;

    @CrmColumn(name = "poi_type", nullable = false, length = 64, note = "poi类型")
    private String poiType;

    @CrmColumn(name = "poi_keyword", nullable = false, length = 32, note = "poi关键字")
    private String poiKeyword;

}
