package com.biz.crm.poi.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 高德POI行业分类表
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_amap_poi_type")
@CrmTable(name = "mdm_amap_poi_type", tableNote = "高德地图行业分类表", indexes = {
        @Index(name = "mdm_amap_poi_type_index1", columnList = "type_code"),
})
public class MdmAmapPoiTypeEntity extends BaseIdEntity {

    @CrmColumn(name = "type_code", nullable = false, unique = true, length = 16, note = "分类编码")
    private String typeCode;

    @CrmColumn(name = "type_name", nullable = false, length = 128, note = "分类名称")
    private String typeName;

    @CrmColumn(name = "type_level", length = 16, note = "分类级别")
    private String typeLevel;

    @CrmColumn(name = "parent_code", length = 16, note = "上级分类编码")
    private String parentCode;

    @CrmColumn(name = "type_category", length = 128, note = "分类范围")
    private String typeCategory;

}
