package com.biz.crm.position.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 职位与用户关联表实体类
 *
 * @author zxw
 * @date 2020-10-10 13:59:04
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_supply")
@CrmTable(name = "mdm_customer_supply",tableNote = "职位与用户关联表实体类",indexes = {
        @Index(name = "mdm_customer_supply_index1",columnList = "position_code"),
        @Index(name = "mdm_customer_supply_index2",columnList = "customer_code"),
        @Index(name = "mdm_customer_supply_index3",columnList = "org_code"),

})
public class MdmCustomerSupplyEntity extends CrmExtTenEntity<MdmCustomerSupplyEntity> {

    /**
     * 职位编码
     */
	@CrmColumn(name = "position_code", length = 64)
    private String positionCode;

    /**
     * 客户编码
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;


    /**
     * 渠道
     */
	@CrmColumn(name = "channel", length = 64)
    private String channel;

    /**
     * 品牌
     */
    @CrmColumn(name = "brand", length = 64)
    private String brand;

    /**
     * 组织编码
     */
	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    @ApiModelProperty("销售公司编码")
	@CrmColumn(name = "sale_company", length = 64)
    private String saleCompany;

}
