package com.biz.crm.position.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 职位与流程角色关联实体类
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_position_bpm_role")
@CrmTable(name = "mdm_position_bpm_role",tableNote = "职位与流程角色关联实体类",indexes = {
        @Index(name = "position_bpm_role_index1",columnList = "position_code")
})
public class MdmPositionBpmRoleEntity extends BaseIdEntity {

    /**
     * 职位编码
     */
	@CrmColumn(name = "position_code", length = 64)
    private String positionCode;

    /**
     * 流程角色编码
     */
	@CrmColumn(name = "bpm_role_code", length = 64)
    private String bpmRoleCode;

}
