package com.biz.crm.position.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 职位表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_position")
@CrmTable(name = "mdm_position",tableNote = "职位表实体类",indexes = {
        @Index(name = "mdm_position_index1",columnList = "position_code",unique = true),
        @Index(name = "mdm_position_index2",columnList = "parent_code",unique = false),
})
public class MdmPositionEntity extends CrmTreeTenEntity<MdmPositionEntity> {

    /**
     * 职位编码
     */
	@CrmColumn(name = "position_code", length = 64)
    private String positionCode;

    /**
     * 职位名称
     */
	@CrmColumn(name = "position_name", length = 128)
    private String positionName;

    /**
     * 关联组织编码
     */
	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 上级职位编码
     */
	@CrmColumn(name = "parent_code", length = 64)
    private String parentCode;

    /**
     * 职位级别编码
     */
	@CrmColumn(name = "position_level_code", length = 64)
    private String positionLevelCode;

}
