package com.biz.crm.position.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 职位-用户关联表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_position_user")
@CrmTable(name = "mdm_position_user",tableNote = "职位-用户关联表实体类")
public class MdmPositionUserEntity extends BaseIdEntity {

    /**
     * 职位编码
     */
	@CrmColumn(name = "position_code", length = 64)
    private String positionCode;

    /**
     * 用户登录名
     */
	@CrmColumn(name = "user_name", length = 64)
    private String userName;

    /**
     * 是否主职位 1是 0否
     */
	@CrmColumn(name = "primary_flag", length = 64)
    private String primaryFlag;

    /**
     * 是否当前职位 1是 0否
     */
	@CrmColumn(name = "current_flag", length = 64)
    private String currentFlag;

}
