package com.biz.crm.positionlevel.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 职位级别实体类
 *
 * @author Tao.Chen
 * @date 2020-10-22 10:56:51
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_position_level")
@CrmTable(name = "mdm_position_level",tableNote = "职位级别实体类",indexes = {
        @Index(name = "mdm_position_level_index1",columnList = "position_level_code",unique = true)
})
public class MdmPositionLevelEntity extends CrmExtTenEntity<MdmPositionLevelEntity> {

    /**
     * 职位级别编码
     */
	@CrmColumn(name = "position_level_code", length = 64)
    private String positionLevelCode;

    /**
     * 职位级别名称
     */
	@CrmColumn(name = "position_level_name", length = 128)
    private String positionLevelName;

    /**
     * 职位级别生成职位名称后缀增长序列号
     */
	@CrmColumn(name = "suffix_sequence", length = 16)
    private Integer suffixSequence;

}
