package com.biz.crm.positionlevel.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 职位级别-角色关联表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_position_level_role")
@CrmTable(name = "mdm_position_level_role",tableNote = "职位级别-角色关联表实体类",indexes = {
        @Index(name = "position_level_role_index1",columnList = "position_level_code")
})
public class MdmPositionLevelRoleEntity extends BaseIdEntity {

    /**
     * 职位级别编码
     */
	@CrmColumn(name = "position_level_code", length = 64)
    private String positionLevelCode;

    /**
     * 角色编码
     */
	@CrmColumn(name = "role_code", length = 64)
    private String roleCode;

}
