package com.biz.crm.pricesetting.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 条件字段分类主表 实体类
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_price_condition_group")
@CrmTable(name = "mdm_price_condition_group",tableNote = "条件字段分类主表 实体类",indexes = {
        @Index(name = "price_condition_group_index1",columnList = "condition_group_code")
})
public class MdmPriceConditionGroupEntity extends CrmExtTenEntity<MdmPriceConditionGroupEntity> {

    /**
     * 条件字段分类编码
     */
	@CrmColumn(name = "condition_group_code", length = 64)
    private String conditionGroupCode;

    /**
     * 条件字段分类描述
     */
	@CrmColumn(name = "condition_group_desc", length = 128)
    private String conditionGroupDesc;

    /**
     * 条件编码组合key(校验编码维度不能重复用)
     */
	@CrmColumn(name = "group_codes_key", length = 64)
    private String groupCodesKey;
}
