package com.biz.crm.pricesetting.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 条件字段分类和字段的关系表 实体类
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_price_group_rel")
@CrmTable(name = "mdm_price_group_rel",tableNote = "条件字段分类和字段的关系表 实体类")
public class MdmPriceConditionGroupRelFieldEntity extends CrmExtTenEntity<MdmPriceConditionGroupRelFieldEntity> {

    /**
     * 条件字段分类编码
     */
	@CrmColumn(name = "condition_group_code", length = 64)
    private String conditionGroupCode;

    /**
     * 字段编码(字典)
     */
	@CrmColumn(name = "field_code", length = 64)
    private String fieldCode;

    /**
     * 字段名称
     */
	@CrmColumn(name = "field_name", length = 128)
    private String fieldName;

}
