package com.biz.crm.pricesetting.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 条件字段类型主表 实体类
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_price_condition_type")
@CrmTable(name = "mdm_price_condition_type",tableNote = "条件字段类型主表",indexes = {
        @Index(name = "price_condition_type_index1",columnList = "condition_type_code")
})
public class MdmPriceConditionTypeEntity extends CrmExtTenEntity<MdmPriceConditionTypeEntity> {

    /**
     * 条件类型编码
     */
	@CrmColumn(name = "condition_type_code", length = 64)
    private String conditionTypeCode;

    /**
     * 条件类型描述
     */
	@CrmColumn(name = "condition_type_desc", length = 128)
    private String conditionTypeDesc;

    /**
     * 条件类型(head:抬头/line:行项目)
     */
	@CrmColumn(name = "condition_type_type", length = 64)
    private String conditionTypeType;
}
