package com.biz.crm.pricesetting.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 条件字段类型和条件字段分类的关系表 实体类
 *
 * @author huanglong
 * @date 2020-10-20 10:57:01
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_price_type_rel")
@CrmTable(name = "mdm_price_type_rel",tableNote = "条件字段类型和条件字段分类的关系表")
public class MdmPriceConditionTypeRelGroupEntity extends CrmExtTenEntity<MdmPriceConditionTypeRelGroupEntity> {

    /**
     * 条件类型编码
     */
	@CrmColumn(name = "condition_type_code", length = 64)
    private String conditionTypeCode;

    /**
     * 条件字段分类编码
     */
	@CrmColumn(name = "condition_group_code", length = 64)
    private String conditionGroupCode;

    /**
     * 条件字段分类名称
     */
	@CrmColumn(name = "condition_group_name", length = 128)
    private String conditionGroupName;

    /**
     * 排序
     */
	@CrmColumn(name = "sort_num", length = 16)
    private Integer sortNum;

}
