package com.biz.crm.pricesetting.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 价格维护主表 实体类
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_price_setting")
@CrmTable(name = "mdm_price_setting",tableNote = "价格维护主表",indexes = {
        @Index(name = "mdm_price_setting_index1",columnList = "customer_code")
})
public class MdmPriceSettingEntity extends CrmExtEntity<MdmPriceSettingEntity> {

    /**
     * 价格设置编码
     */
	@CrmColumn(name = "price_setting_code", length = 64)
    private String priceSettingCode;

    /**
     * 条件类型编码
     */
	@CrmColumn(name = "condition_type_code", length = 64)
    private String conditionTypeCode;

    /**
     * 条件字段分类编码
     */
	@CrmColumn(name = "condition_group_code", length = 64)
    private String conditionGroupCode;

    /**
     * 企业组织编码
     */
	@CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 企业组织名称
     */
	@CrmColumn(name = "org_name", length = 128)
    private String orgName;

    /**
     * 渠道编码
     */
	@CrmColumn(name = "channel", length = 64)
    private String channel;

    /**
     * 渠道名称
     */
	@CrmColumn(name = "channel_name", length = 128)
    private String channelName;

    /**
     * 客户编码
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 客户名称
     */
	@CrmColumn(name = "customer_name", length = 128)
    private String customerName;

    /**
     * 商品编码
     */
	@CrmColumn(name = "product_code", length = 64)
    private String productCode;

    /**
     * 商品名称
     */
	@CrmColumn(name = "product_name", length = 128)
    private String productName;

    /**
     * 价格
     */
	@CrmColumn(name = "price", length = 64)
    private BigDecimal price;

    /**
     * 单位类型 unit_type
     */
	@CrmColumn(name = "unit_type", length = 64)
    private String unitType;

    /**
     * 币种编码(字典)
     */
	@CrmColumn(name = "currency_type", length = 64)
    private String currencyType;

    /**
     * 币种名称
     */
	@CrmColumn(name = "currency_type_name", length = 64)
    private String currencyTypeName;

    /**
     * 价格单位(字典,选项数据跟选择的商品有关)
     */
	@CrmColumn(name = "price_unit", length = 64)
    private String priceUnit;

    /**
     * 价格单位名称
     */
	@CrmColumn(name = "price_name", length = 128)
    private String priceName;

    /**
     * 有效期开始日期
     */
	@CrmColumn(name = "begin_date", length = 64)
    private String beginDate;

    /**
     * 有效期开始时间
     */
	@CrmColumn(name = "begin_date_second", length = 64)
    private String beginDateSecond;

    /**
     * 有效期结束日期
     */
	@CrmColumn(name = "end_date", length = 64)
    private String endDate;

    /**
     * 有效期结束时间
     */
	@CrmColumn(name = "end_date_second", length = 64)
    private String endDateSecond;

    @ApiModelProperty("价格组")
	@CrmColumn(name = "price_group", length = 64)
    private String priceGroup;

    @ApiModelProperty("终端编码")
	@CrmColumn(name = "terminal_code", length = 64)
    private String terminalCode;

    @CrmColumn(name = "customer_org_name", length = 128)
    private String customerOrgName;

    @CrmColumn(name = "customer_type", length = 64,note = "客户类型")
    private String customerType;

    @CrmColumn(name = "terminal_type", length = 64,note = "终端类型")
    private String terminalType;

}
