package com.biz.crm.product.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * 商品主表实体类
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_product")
@Api(tags = "MDM-商品主表实体")
@CrmTable(name = "mdm_product",tableNote = "MDM-商品主表实体",indexes = {
        @Index(name = "mdm_product_index1",columnList = "product_code",unique = true),
        @Index(name = "mdm_product_index2",columnList = "product_level_code")
})
public class MdmProductEntity extends CrmExtEntity<MdmProductEntity> {

    /**
     * 商品编码
     */
	@CrmColumn(name = "product_code", length = 64)
    private String productCode;

    /**
     * 商品名称
     */
	@CrmColumn(name = "product_name", length = 128)
    private String productName;

    /**
     * 产品层级编码
     */
	@CrmColumn(name = "product_level_code", length = 64)
    private String productLevelCode;

    /**
     * 商品类型(数据字典)
     */
	@CrmColumn(name = "product_type", length = 64)
    private String productType;

    /**
     * 销售单位
     */
	@CrmColumn(name = "sale_unit", length = 64)
    private String saleUnit;

    /**
     * 规格
     */
	@CrmColumn(name = "spec", length = 64)
    private String spec;

    /**
     * 基本单位
     */
	@CrmColumn(name = "base_unit", length = 64)
    private String baseUnit;

    /**
     * 开始日期
     */
	@CrmColumn(name = "begin_date", length = 64)
    private String beginDate;

    /**
     * 开始时间
     */
	@CrmColumn(name = "begin_date_second", length = 64)
    private String beginDateSecond;

    /**
     * 结束日期
     */
	@CrmColumn(name = "end_date", length = 64)
    private String endDate;
    /**
     * 结束时间
     */
	@CrmColumn(name = "end_date_second", length = 64)
    private String endDateSecond;

    /**
     * 上下架状态(数据字典)
     */
	@CrmColumn(name = "is_shelf", length = 64)
    private String isShelf;

    /**
     * 条形码
     */
	@CrmColumn(name = "bar_code", length = 64)
    private String barCode;

    @ApiModelProperty("是否维护图片1是0否")
	@CrmColumn(name = "maintenance_picture", length = 64)
    private String maintenancePicture;

    @ApiModelProperty("是否维护详情1是0否")
	@CrmColumn(name = "maintenance_introduction", length = 64)
    private String maintenanceIntroduction;

    @ApiModelProperty("销售公司")
	@CrmColumn(name = "sale_company", length = 64)
    private String saleCompany;

    @ApiModelProperty("sfa图片地址")
    @CrmColumn(name = "pic_url",length = 255,note = "sfa图片地址")
    private String picUrl;

    @ApiModelProperty("主图片url")
    @CrmColumn(name = "primary_picture_url",length = 255,note = "主图片url")
    private String primaryPictureUrl;
}
