package com.biz.crm.product.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.Api;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author huang.long
 * @date 2020-09-01 15:18:14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_product_introduction")
@Api(tags = "MDM-商品富文本实体")
@CrmTable(name = "mdm_product_introduction",tableNote = "MDM-商品富文本实体",indexes = {
        @Index(name = "mdm_product_introduction_index1",columnList = "product_code")
})
public class MdmProductIntroductionEntity extends CrmBaseEntity<MdmProductIntroductionEntity> {

    /**
     * 商品编码
     */
	@CrmColumn(name = "product_code", length = 64)
    private String productCode;

    /**
     * 富文本介绍
     */
	@CrmColumn(name = "introduction_text", length = 10000)
    private String introductionText;

}
