package com.biz.crm.product.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.Api;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 实体类
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_product_material")
@Api(tags = "MDM-商品与物料关系实体")
@CrmTable(name = "mdm_product_material",tableNote = "MDM-商品与物料关系实体",indexes = {
        @Index(name = "mdm_product_material_index1",columnList = "material_code"),
        @Index(name = "mdm_product_material_index2",columnList = "product_code")
})
public class MdmProductMaterialEntity extends CrmExtTenEntity<MdmProductMaterialEntity> {

    /**
     * 物料数量
     */
	@CrmColumn(name = "count", length = 64)
    private Integer count;

    /**
     * 物料编码
     */
	@CrmColumn(name = "material_code", length = 64)
    private String materialCode;

    /**
     * 商品编码
     */
	@CrmColumn(name = "product_code", length = 64)
    private String productCode;

    /**
     * 比例
     */
	@CrmColumn(name = "ratio", length = 64)
    private BigDecimal ratio;

}
