package com.biz.crm.product.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.Api;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 实体类
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_product_media")
@Api(tags = "MDM-商品图片视频实体")
@CrmTable(name = "mdm_product_media",tableNote = "商品图片视频")
public class MdmProductMediaEntity extends CrmBaseEntity<MdmProductMediaEntity> {

    /**
     * 图片地址
     */
	@CrmColumn(name = "url_address", length = 255)
    private String urlAddress;
    /**
     * 排序位置
     */
	@CrmColumn(name = "range_num", length = 64)
    private Integer rangeNum;
    /**
     * 商品编码
     */
	@CrmColumn(name = "product_code", length = 64)
    private String productCode;
    /**
     * 文件类型('picture'图片,'video'视频)
     */
	@CrmColumn(name = "type", length = 64)
    private String type;

	@CrmColumn(name = "file_name", length = 128)
    private String fileName;

	@CrmColumn(name = "original_file_name", length = 128)
    private String originalFileName;

	@CrmColumn(name = "relative_local", length = 128)
    private String relativeLocal;
}
