package com.biz.crm.productlevel.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_product_level")
@CrmTable(name = "mdm_product_level",tableNote = "产品层级",indexes = {
        @Index(name = "mdm_product_level_index1",columnList = "product_level_code",unique = true),
        @Index(name = "mdm_product_level_index2",columnList = "parent_code",unique = false),

})
public class MdmProductLevelEntity extends CrmTreeEntity<MdmProductLevelEntity> {

    /**
     * 上级编码
     */
	@CrmColumn(name = "parent_code", length = 64)
    private String parentCode;

    /**
     * 产品层级编码
     */
	@CrmColumn(name = "product_level_code", length = 64)
    private String productLevelCode;

    /**
     * 产品层级名称
     */
	@CrmColumn(name = "product_level_name", length = 128)
    private String productLevelName;

    /**
     * 产品层级类型
     */
	@CrmColumn(name = "product_level_type", length = 64)
    private String productLevelType;

}
