package com.biz.crm.region.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-11-20 14:59:37
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_region")
@CrmTable(name = "mdm_region", tableNote = "行政区域", indexes = {
        @Index(name = "mdm_region_index1", unique = true, columnList = "region_code"),
        @Index(name = "mdm_region_index2", columnList = "parent_code"),
        @Index(name = "mdm_region_index3", columnList = "gov_region_code"),
        @Index(name = "mdm_region_index4", columnList = "gov_parent_code")
})
public class MdmRegionEntity extends CrmExtTenEntity<MdmRegionEntity> {

    @CrmColumn(name = "region_code", length = 16, nullable = false, unique = true, note = "CRM行政区域编码")
    private String regionCode;

    @CrmColumn(name = "region_name", length = 64, nullable = false, note = "CRM行政区域名称")
    private String regionName;

    @CrmColumn(name = "parent_code", length = 16, note = "CRM上级行政区域编码")
    private String parentCode;

    @CrmColumn(name = "region_level", length = 1, nullable = false, note = "区域等级")
    private String regionLevel;

    @CrmColumn(name = "gov_region_code", length = 16, note = "国家统计局行政区域编码")
    private String govRegionCode;

    @CrmColumn(name = "gov_parent_code", length = 16, note = "国家统计局上级行政区域编码")
    private String govParentCode;

    @CrmColumn(name = "gov_url", length = 128, note = "国家统计局URL")
    private String govUrl;

    @CrmColumn(name = "email", length = 8, note = "邮政编码")
    private String email;

    @CrmColumn(name = "longitude", length = 16, note = "经度")
    private String longitude;

    @CrmColumn(name = "latitude", length = 16, note = "纬度")
    private String latitude;

    @CrmColumn(name = "has_child", length = 8, note = "是否有子节点")
    private Boolean hasChild;

}
