package com.biz.crm.role.mode;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;



/**
 * 职位用户关联表
 *
 * @author zxw
 * @date 2020-10-23 23:19
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_role_customer")
@AllArgsConstructor
@NoArgsConstructor
@CrmTable(name = "mdm_role_customer",tableNote = "职位用户关联表")
@Deprecated
public class MdmRoleCustomerEntity extends BaseIdEntity {

    /**
     * 客户编码
     */
	@CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 角色编码
     */
	@CrmColumn(name = "role_code", length = 64)
    private String roleCode;
}
