package com.biz.crm.shoppingcart.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 购物车
 * @Author: zhangyuzhu
 * @Date: 2020/10/20 9:56
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("mdm_shopping_cart")
@CrmTable(name = "mdm_shopping_cart",tableNote = "购物车")
public class ShoppingCartEntity extends CrmExtEntity<ShoppingCartEntity> {

    /**
     * 账号
     */
	@CrmColumn(name = "account", length = 64)
    private String account;

    /**
     * 客户编码
     */
	@CrmColumn(name = "cus_code", length = 64)
    private String cusCode;


    /**
     * 商品编码
     */
	@CrmColumn(name = "goods_code", length = 64)
    private String goodsCode;

    /**
     * 商品名称
     */
	@CrmColumn(name = "goods_name", length = 64)
    private String goodsName;

    /**
     * 数量
     */
	@CrmColumn(name = "num", length = 64)
    private Integer num;
}
