package com.biz.crm.sys.index.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.sys.index.entity
 * @Description: TODO
 * @date 2020/11/24 下午12:55
 */
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("mdm_index_config")
@Data
@ApiModel(value = "MdmIndexConfigEntity", description = "首页配置实体")
@CrmTable(name = "mdm_index_config",tableNote = "首页配置实体")
public class MdmIndexConfigEntity extends CrmBaseEntity<MdmIndexConfigEntity> {
    /** 类型 */
    @ApiModelProperty("类型 1：后台，2小程序")
	@CrmColumn(name = "data_type", length = 64)
    private String dataType ;
    /** 模板名称 */
	@CrmColumn(name = "template_name", length = 64)
    private String templateName ;
    /** 登录页标题 */
	@CrmColumn(name = "index_title", length = 64)
    private String indexTitle ;
    /** 服务热线 */
	@CrmColumn(name = "service_phone", length = 64)
    private String servicePhone ;
    /** 客服电话 */
	@CrmColumn(name = "client_phone", length = 64)
    private String clientPhone ;
    /** 备案号 */
	@CrmColumn(name = "record_no", length = 64)
    private String recordNo ;
    /** 公司名称 */
	@CrmColumn(name = "company_name", length = 64)
    private String companyName ;
    /** 登录按钮颜色 */
	@CrmColumn(name = "button_colour", length = 64)
    private String buttonColour ;
    /** 底部文字 */
	@CrmColumn(name = "bottom_text", length = 64)
    private String bottomText ;
    /** 首行企业logo图片 */
	@CrmColumn(name = "logo_url", length = 200)
    private String logoUrl ;
    /** 后台系统菜单logo图片地址 */
	@CrmColumn(name = "system_menu_logo_url", length = 200, note = "后台系统菜单logo图片地址")
    private String systemMenuLogoUrl ;
    @CrmColumn(name = "sfa_applets_welcome_url", length = 200, note = "sfa小程序欢迎图片地址")
    private String sfaAppletsWelcomeUrl ;
    /** sfa小程序logo图片地址 */
	@CrmColumn(name = "sfa_applets_logo_url", length = 200, note = "sfa小程序logo图片地址")
    private String sfaAppletsLogoUrl ;
    /** cps小程序logo图片地址 */
	@CrmColumn(name = "cps_applets_logo_url", length = 200, note = "cps小程序logo图片地址")
    private String cpsAppletsLogoUrl ;
    /** dms小程序商城logo图片地址 */
	@CrmColumn(name = "dms_applets_mall_logo_url", length = 200, note = "dms小程序商城logo图片地址")
    private String dmsAppletsMallLogoUrl ;
    /** 长中部长轮播时间 */
	@CrmColumn(name = "logo_time", length = 64)
    private String logoTime ;
    @ApiModelProperty("首页url地址")
	@CrmColumn(name = "pc_first_url", length = 64)
    private String pcFirstUrl;
}
