package com.biz.crm.tableconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 字段配置实体类
 *
 * @author zxw
 * @date 2020-11-21 12:19:06
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_column_config")
@CrmTable(name = "mdm_column_config",indexes = {
        @Index(name ="mdm_column_config_index1",columnList = "parent_code,function_code,field",unique = true)
})
public class MdmColumnConfigEntity extends CrmBaseEntity<MdmColumnConfigEntity> {

    @ApiModelProperty("菜单编码")
    @CrmColumn(name = "parent_code", length = 64, nullable = false)
    private String parentCode;

    @ApiModelProperty("是否导出，1是0否")
    @CrmColumn(name = "column_export", length = 64)
    private String columnExport;

    @ApiModelProperty("功能编码")
    @CrmColumn(name = "function_code", length = 64, nullable = false)
    private String functionCode;

    @ApiModelProperty("属性")
    @CrmColumn(name = "field", length = 64)
    private String field;

    @ApiModelProperty("标签")
    @CrmColumn(name = "title", length = 64)
    private String title;

    @ApiModelProperty("显示模式：1显示，0隐藏")
    @CrmColumn(name = "visible", length = 8)
    private String visible;

    @ApiModelProperty("新增页面时候编辑状态")
    @CrmColumn(name = "editable_in_create", length = 8)
    private String editableInCreate;

    @ApiModelProperty("编辑页面编辑状态")
    @CrmColumn(name = "editable_in_edit", length = 8)
    private String editableInEdit;

    @ApiModelProperty("编辑页面显隐")
    @CrmColumn(name = "visible_in_edit", length = 8)
    private String visibleInEdit;

    @ApiModelProperty("查看页面显隐")
    @CrmColumn(name = "visible_in_look", length = 8)
    private String visibleInLook;

    @ApiModelProperty("对齐方式")
    @CrmColumn(name = "align", length = 64)
    private String align;

    @ApiModelProperty("类型")
    @CrmColumn(name = "type", length = 64)
    private String type;

    @ApiModelProperty("宽度")
    @CrmColumn(name = "width", length = 64)
    private String width;

    @ApiModelProperty("顺序")
    @CrmColumn(name = "formorder", length = 64)
    private String formorder;

    @ApiModelProperty("位置")
    @CrmColumn(name = "fixed", length = 8)
    private String fixed;

    @ApiModelProperty("是否展示省略号1展示，0不展示")
    @CrmColumn(name = "show_overflow", length = 8)
    private String showOverflow;

    @ApiModelProperty("是否必填")
    @CrmColumn(name = "required", length = 8)
    private String required;

    @ApiModelProperty("数据字典编码")
    @CrmColumn(name = "dict_code", length = 64)
    private String dictCode;

    @ApiModelProperty("列样式")
    @CrmColumn(name = "col", length = 64)
    @SaturnColumn(description = "列样式")
    private String col;

//    @ApiModelProperty("校验")
//    @SaturnColumn(description = "校验")
//    private String validate;

    @ApiModelProperty("事件")
    @SaturnColumn(description = "事件")
    @CrmColumn(name = "formon", length = 64)
    private String formon;

    @ApiModelProperty("操作")
    @SaturnColumn(description = "操作")
    @CrmColumn(name = "formoptions", length = 64)
    private String formoptions;


    @ApiModelProperty("属性")
    @SaturnColumn(description = "属性")
    @CrmColumn(name = "props", length = 64)
    private String props;

    @ApiModelProperty("刷新")
    @SaturnColumn(description = "刷新1是0否")
    @CrmColumn(name = "refresh", length = 64)
    private String refresh;

    @ApiModelProperty("值")
    @SaturnColumn(description = "值")
    @CrmColumn(name = "formvalue", length = 64)
    private String formvalue;

    @ApiModelProperty("控件")
    @SaturnColumn(description = "控件")
    @CrmColumn(name = "class_name", length = 64)
    private String className;

    @ApiModelProperty("字段是否搜索")
    @CrmColumn(name = "search", length = 64)
    private String search;

    @ApiModelProperty("请求地址")
    @CrmColumn(name = "request_url", length = 500)
    private String requestUrl;

    @ApiModelProperty("下拉框是否搜索")
    @CrmColumn(name = "request_search", length = 64)
    private String requestSearch;

    @ApiModelProperty("是否查看详情")
    @CrmColumn(name = "edit_view", length = 64)
    private String editView;

    @ApiModelProperty("查询方式-1不作查询,0精确查询，1模糊查询，2范围查询，3左模糊查询，4右模糊查询，5小于，6小于等于，7大于，8大于等于")
    @CrmColumn(name = "search_type", length = 64)
    private String searchType;

    @ApiModelProperty("实体字段名称")
    @CrmColumn(name = "entity_field_name", length = 64)
    private String entityFieldName;

    @ApiModelProperty("列表控件类型")
    @CrmColumn(name = "form_control", length = 64)
    private String formControl;

}
