package com.biz.crm.tableconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 字段配置个性设置实体类
 *
 * @author Tao.Chen
 * @date 2021-02-20 15:30:42
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_column_config_personal")
@CrmTable(name = "mdm_column_config_personal",tableNote = "字段配置个性设置实体类",indexes = {
        @Index(name = "column_config_personal_index1",columnList = "parent_code")
})
public class MdmColumnConfigPersonalEntity extends CrmBaseEntity<MdmColumnConfigPersonalEntity> {

    /**
     * 当前职位编码
     */
	@CrmColumn(name = "position_code", length = 64)
    private String positionCode;

    /**
     * 上级菜单编码
     */
	@CrmColumn(name = "parent_code", length = 64)
    private String parentCode;

    /**
     * 功能菜单编码
     */
	@CrmColumn(name = "function_code", length = 64)
    private String functionCode;

    /**
     * 属性
     */
	@CrmColumn(name = "field", length = 64)
    private String field;

    /**
     * 显示模式：1显示，0隐藏
     */
	@CrmColumn(name = "visible", length = 64)
    private String visible;

    /**
     * 顺序
     */
	@CrmColumn(name = "form_order", length = 64)
    private String formOrder;

}
